import { Card, MbscCardOptions } from '../classes/cards';
export { Card, MbscCardOptions };
import { Calendar, MbscCalendarOptions } from '../presets/calendar';
export { Calendar, MbscCalendarOptions };
import { Color, MbscColorOptions } from '../classes/color';
export { Color, MbscColorOptions };
import { MbscDatetimeOptions } from '../presets/datetimebase';
import { DateTime } from '../presets/datetime';
export { DateTime, MbscDatetimeOptions };
import { Eventcalendar, MbscEventcalendarOptions } from '../presets/eventcalendar';
export { Eventcalendar, MbscEventcalendarOptions };
import { Form, MbscFormOptions } from '../classes/forms';
export { Form, MbscFormOptions };
import { Page, MbscPageOptions } from '../classes/page';
export { Page, MbscPageOptions };
import { ImageScroller, MbscImageOptions } from '../presets/image';
export { ImageScroller, MbscImageOptions };
import { ListView, MbscListviewOptions } from '../classes/listview';
export { ListView, MbscListviewOptions };
import { Optionlist, MbscOptionlistOptions } from '../classes/optionlist';
export { Optionlist, MbscOptionlistOptions };
import { Measurement, MbscMeasurementOptions } from '../presets/measurement';
import { Mass, MbscMassOptions } from '../presets/mass';
import { Distance, MbscDistanceOptions } from '../presets/distance';
import { Force, MbscForceOptions } from '../presets/force';
import { Speed, MbscSpeedOptions } from '../presets/speed';
import { Temperature, MbscTemperatureOptions } from '../presets/temperature';
export { Measurement, Mass, Distance, Force, Speed, Temperature, MbscMeasurementOptions, MbscMassOptions, MbscForceOptions, MbscSpeedOptions, MbscTemperatureOptions, MbscDistanceOptions };
import { Navigation, MbscNavOptions } from '../classes/navigation';
export { Navigation, MbscNavOptions };
import { NumberScroller, MbscNumberOptions } from '../presets/number';
export { NumberScroller, MbscNumberOptions };
import { Numpad, MbscNumpadOptions, MbscNumpadDateOptions, MbscNumpadDecimalOptions, MbscNumpadTimeOptions, MbscNumpadTimespanOptions } from '../classes/numpad';
export { Numpad, MbscNumpadOptions, MbscNumpadDateOptions, MbscNumpadDecimalOptions, MbscNumpadTimeOptions, MbscNumpadTimespanOptions };
import { RangePicker, MbscRangeOptions } from '../presets/range';
export { RangePicker, MbscRangeOptions };
import { Scroller, MbscScrollerOptions } from '../classes/scroller';
export { Scroller, MbscScrollerOptions };
import { ScrollView, MbscScrollViewOptions } from '../classes/scrollview';
export { ScrollView, MbscScrollViewOptions };
import { Select, MbscSelectOptions } from '../presets/select';
export { Select, MbscSelectOptions };
import { Timer, MbscTimerOptions } from '../presets/timer';
export { Timer, MbscTimerOptions };
import { Timespan, MbscTimespanOptions } from '../presets/timespan';
export { Timespan, MbscTimespanOptions };
import { Treelist, MbscTreelistOptions } from '../presets/treelist';
export { Treelist, MbscTreelistOptions };
import { Popup, MbscPopupOptions } from '../classes/popup';
export { Popup, MbscPopupOptions };
import { Widget, MbscWidgetOptions } from '../classes/popup';
export { Widget, MbscWidgetOptions };

import { IMobiscroll as _IMobiscroll } from '../core/core';

export interface IMobiscroll extends _IMobiscroll {
    card(selector: string | HTMLElement, options?: MbscCardOptions): Card;
    calendar(selector: string | HTMLElement, options?: MbscCalendarOptions): Calendar;
    color(selector: string | HTMLElement, options?: MbscColorOptions): Color;
    datetime(selector: string | HTMLElement, options?: MbscDatetimeOptions): DateTime;
    date(selector: string | HTMLElement, options?: MbscDatetimeOptions): DateTime;
    time(selector: string | HTMLElement, options?: MbscDatetimeOptions): DateTime;
    eventcalendar(selector: string | HTMLElement, options?: MbscEventcalendarOptions): Eventcalendar;
    form(selector: string | HTMLElement, options?: MbscFormOptions): Form;
    page(selector: string | HTMLElement, options?: MbscPageOptions): Page;
    image(selector: string | HTMLElement, options?: MbscImageOptions): ImageScroller;
    listview(selector: string | HTMLElement, options?: MbscListviewOptions): ListView;
    optionlist(selector: string | HTMLElement, options?: MbscOptionlistOptions): Optionlist;
    measurement(selector: string | HTMLElement, options?: MbscMeasurementOptions): Measurement;
    mass(selector: string | HTMLElement, options?: MbscMassOptions): Mass;
    distance(selector: string | HTMLElement, options?: MbscDistanceOptions): Distance;
    force(selector: string | HTMLElement, options?: MbscForceOptions): Force;
    speed(selector: string | HTMLElement, options?: MbscSpeedOptions): Speed;
    temperature(selector: string | HTMLElement, options?: MbscTemperatureOptions): Temperature;
    nav(selector: string | HTMLElement, options?: MbscNavOptions): Navigation;
    number(selector: string | HTMLElement, options?: MbscNumberOptions): NumberScroller;
    numpad(selector: string | HTMLElement, options?: MbscNumpadOptions): Numpad;
    range(selector: string | HTMLElement, options?: MbscRangeOptions): RangePicker;
    scroller(selector: string | HTMLElement, options?: MbscScrollerOptions): Scroller;
    scrollview(selector: string | HTMLElement, options?: MbscScrollViewOptions): ScrollView;
    select(selector: string | HTMLElement, options?: MbscSelectOptions): Select;
    timer(selector: string | HTMLElement, options?: MbscTimerOptions): Timer;
    timespan(selector: string | HTMLElement, options?: MbscTimespanOptions): Timespan;
    treelist(selector: string | HTMLElement, options?: MbscTreelistOptions): Treelist;
    popup(selector: string | HTMLElement, options?: MbscPopupOptions): Popup;
    widget(selector: string | HTMLElement, options?: MbscWidgetOptions): Widget;
}

export const mobiscroll: IMobiscroll;
export as namespace mobiscroll;
export default mobiscroll;
